#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef VERDANA24_H
#define VERDANA24_H

#define VERDANA24_WIDTH 17
#define VERDANA24_HEIGHT 24

/*
 * define for backward compatiblity
 */
#define Verdana24 Verdana_digits_24

static const uint8_t Verdana_digits_24[] PROGMEM = {
    0x0E, 0xF9, // size
    0x11, // width
    0x18, // height
    0x30, // first char
    0x0B, // char count

    // char widths
    0x10, 0x0D, 0x0F, 0x0F, 0x11, 0x0F, 0x10, 0x10, 0x10, 0x10,
    0x04,

    // font data
    0x80, 0xF0, 0xFC, 0x7E, 0x0E, 0x0F, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1E,
0x7E, 0xFC, 0xF0, 0x80, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x0F, 0x3F, 0x7E,
0x70, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xF0, 0x70, 0x7E, 0x3F, 0x0F, 0x01, //48 '0'

    0x38, 0x38, 0x38, 0x38, 0x3C, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
0x00, 0x00, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0,
0xE0, 0xE0, 0xE0,                                                        // 49 '1'

    0x00, 0x1E, 0x0E, 0x0E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1E, 0xFE,
0xFC, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF0,
0x78, 0x3E, 0x1F, 0x07, 0x01, 0x00, 0xF0, 0xF8, 0xFC, 0xFE, 0xEF, 0xE7,
0xE3, 0xE1, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0,                    // 50 '2'

    0x00, 0x1E, 0x0E, 0x0E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1E,
0xFE, 0xFC, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x1C,
0x1E, 0x36, 0x77, 0xF3, 0xE1, 0xC0, 0x78, 0x70, 0x70, 0xF0, 0xE0, 0xE0,
0xE0, 0xE0, 0xE0, 0xF0, 0x70, 0x78, 0x3F, 0x1F, 0x0F,                   // 51 '3'

    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xF0, 0xF8, 0x7C, 0x1E, 0xFF,
0xFF, 0xFF, 0x00, 0x00, 0x00, 0xE0, 0xF0, 0xFC, 0xFE, 0xDF, 0xC7, 0xC3,
0xC1, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0xC0, 0x01, 0x01,
0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0xFF, 0xFF,
0x01, 0x01, 0x01,                                                       // 52 '4'

    0x00, 0xFF, 0xFF, 0xFF, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
0x07, 0x07, 0x07, 0x00, 0x1F, 0x1F, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
0x1E, 0x1C, 0x3C, 0xF8, 0xF8, 0xE0, 0x78, 0x70, 0x70, 0xF0, 0xE0, 0xE0,
0xE0, 0xE0, 0xE0, 0xF0, 0x70, 0x7C, 0x3F, 0x1F, 0x07,                    // 53 '5'

    0x00, 0xC0, 0xF0, 0xF8, 0x3C, 0x1E, 0x0E, 0x0E, 0x07, 0x07, 0x07, 0x07,
0x07, 0x0F, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0x1C, 0x1C, 0x0E, 0x0E, 0x0E,
0x0E, 0x0E, 0x0E, 0x1E, 0x3C, 0xF8, 0xF8, 0xE0, 0x03, 0x0F, 0x3F, 0x7C,
0x78, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x70, 0x78, 0x3F, 0x1F, 0x07, //54 '6'

    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x87,
0xE7, 0xFF, 0x7F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
0xF0, 0xFC, 0x3F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0,
0xF8, 0xFC, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //55 '7'

    0x00, 0xF0, 0xFC, 0xFE, 0x0E, 0x0F, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1E,
0xFE, 0xFC, 0xF8, 0x00, 0x80, 0xE0, 0xF3, 0x77, 0x1F, 0x0E, 0x0E, 0x0C,
0x1C, 0x1C, 0x1C, 0x3E, 0x77, 0xF3, 0xE0, 0x80, 0x0F, 0x1F, 0x3F, 0x78,
0x70, 0xF0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x70, 0x78, 0x3F, 0x1F, 0x0F, //56 '8'

    0xE0, 0xF8, 0xFC, 0x1E, 0x0E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0F, 0x1E,
0x3E, 0xFC, 0xF0, 0xC0, 0x07, 0x1F, 0x1F, 0x3C, 0x78, 0x70, 0x70, 0x70,
0x70, 0x70, 0x70, 0x38, 0x38, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0xF0, 0xE0,
0xE0, 0xE0, 0xE0, 0xE0, 0x70, 0x70, 0x78, 0x3C, 0x1F, 0x0F, 0x03, 0x00,    //57 '9'

    0xC0, 0xC0, 0xC0, 0xC0, 0x03, 0x03, 0x03, 0x03, 0xF0, 0xF0, 0xF0, 0xF0 // 58 ':'

};

#endif
